/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.routes;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.routes.VWRouteTabbedPane;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.event.IVWExpressionToolbarActionListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWExpressionToolbarActionEvent;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionBuilderDialog;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionToolbar;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWRouteConditionPanel
extends JPanel
implements ActionListener,
DocumentListener,
IVWExpressionToolbarActionListener,
MouseListener,
IVWPropertyChangeSource {
    protected JRadioButton m_trueRadio = null;
    protected JRadioButton m_conditionRadio = null;
    protected VWRouteTabbedPane m_routeTabbedPane = null;
    protected JButton m_insertButton = null;
    protected VWExpressionToolbar m_expressionToolbar = null;
    protected JTextArea m_conditionArea = null;
    protected JScrollPane m_conditionScrollPane = null;
    protected Vector m_controls = null;
    protected VWRouteDefinition m_routeDefinition = null;
    protected VWAuthPropertyData m_authPropertyData = null;
    protected Vector m_changedItems = null;

    public VWRouteConditionPanel(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.createControls();
    }

    public void setEnabled(boolean bEnable) {
        super.setEnabled(bEnable);
        if (this.m_controls == null) {
            return;
        }
        for (int i = 0; i < this.m_controls.size(); ++i) {
            JComponent component = (JComponent)this.m_controls.elementAt(i);
            if (component == null) continue;
            component.setEnabled(bEnable);
        }
        this.enableExpressionControls(this.m_conditionRadio.isSelected());
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_trueRadio)) {
                if (this.m_routeDefinition != null) {
                    this.m_routeDefinition.setCondition(null);
                    this.m_conditionArea.setText(null);
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(this.m_routeDefinition);
                    this.notifyPropertyChange();
                }
                this.enableExpressionControls(false);
            } else if (event.getSource().equals(this.m_conditionRadio)) {
                this.enableExpressionControls(true);
            } else if (event.getSource().equals(this.m_insertButton)) {
                this.m_conditionArea.insert(this.m_routeTabbedPane.getConditionString(), this.m_conditionArea.getCaretPosition());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        this.updateRouteCondition();
    }

    public void removeUpdate(DocumentEvent event) {
        this.updateRouteCondition();
    }

    public void expressionToolbarActionPerformed(VWExpressionToolbarActionEvent event) {
        if (event.getSource().equals(this.m_expressionToolbar)) {
            switch (event.getID()) {
                case 3: {
                    this.m_conditionArea.setText("");
                    break;
                }
                case 4: {
                    this.m_conditionArea.insert(event.getData().toString(), this.m_conditionArea.getCaretPosition());
                }
            }
        }
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getSource().equals(this.m_conditionArea) && this.m_conditionArea.isEnabled() && event.getClickCount() == 2) {
            this.launchExpressionBuilder();
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void notifyPropertyChange() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 503);
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    protected void setSelectedRoute(VWRouteDefinition routeDefinition) {
        try {
            String routeCondition = null;
            this.m_routeDefinition = routeDefinition;
            if (routeDefinition != null) {
                routeCondition = routeDefinition.getCondition();
                this.m_trueRadio.removeActionListener(this);
                this.m_conditionRadio.removeActionListener(this);
                if (routeCondition == null) {
                    this.m_trueRadio.setSelected(true);
                    this.enableExpressionControls(false);
                } else {
                    this.m_conditionRadio.setSelected(true);
                    this.enableExpressionControls(true);
                }
                this.m_trueRadio.addActionListener(this);
                this.m_conditionRadio.addActionListener(this);
            }
            this.m_routeTabbedPane.setSelectedRoute(routeDefinition);
            this.m_conditionArea.getDocument().removeDocumentListener(this);
            this.m_conditionArea.setText(routeCondition);
            this.m_conditionArea.getDocument().addDocumentListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void releaseReferences() {
        if (this.m_trueRadio != null) {
            this.m_trueRadio.removeActionListener(this);
            this.m_trueRadio.removeAll();
            this.m_trueRadio = null;
        }
        if (this.m_conditionRadio != null) {
            this.m_conditionRadio.removeActionListener(this);
            this.m_conditionRadio.removeAll();
            this.m_conditionRadio = null;
        }
        if (this.m_routeTabbedPane != null) {
            this.m_routeTabbedPane.releaseReferences();
            this.m_routeTabbedPane = null;
        }
        if (this.m_insertButton != null) {
            this.m_insertButton.removeActionListener(this);
            this.m_insertButton.removeAll();
            this.m_insertButton = null;
        }
        if (this.m_expressionToolbar != null) {
            this.m_expressionToolbar.removeExpressionToolbarActionListener(this);
            this.m_expressionToolbar.removeAll();
            this.m_expressionToolbar = null;
        }
        if (this.m_conditionArea != null) {
            this.m_conditionArea.getDocument().removeDocumentListener(this);
            this.m_conditionArea.removeAll();
            this.m_conditionArea = null;
        }
        if (this.m_conditionScrollPane != null) {
            this.m_conditionScrollPane.removeAll();
            this.m_conditionScrollPane = null;
        }
        if (this.m_controls != null) {
            this.m_controls.removeAllElements();
            this.m_controls = null;
        }
        if (this.m_changedItems != null) {
            this.m_changedItems.removeAllElements();
            this.m_changedItems = null;
        }
        this.m_routeDefinition = null;
        this.m_authPropertyData = null;
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            this.m_controls = new Vector();
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(0, 4, 0, 4);
            ButtonGroup buttonGroup = new ButtonGroup();
            this.m_trueRadio = new JRadioButton(VWResource.s_routeAlwaysTrue, true);
            this.m_trueRadio.addActionListener(this);
            buttonGroup.add(this.m_trueRadio);
            this.add((Component)this.m_trueRadio, gbCons);
            this.m_controls.addElement(this.m_trueRadio);
            ++gbCons.gridx;
            this.m_conditionRadio = new JRadioButton(VWResource.s_conditionalRoute, false);
            this.m_conditionRadio.addActionListener(this);
            buttonGroup.add(this.m_conditionRadio);
            this.add((Component)this.m_conditionRadio, gbCons);
            this.m_controls.addElement(this.m_conditionRadio);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 0;
            this.add((Component)this.createExpressionPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createExpressionPanel() {
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 0;
            gbCons.insets = new Insets(4, 1, 0, 15);
            this.m_routeTabbedPane = new VWRouteTabbedPane(this.m_authPropertyData);
            panel.add((Component)this.m_routeTabbedPane, gbCons);
            this.m_controls.addElement(this.m_routeTabbedPane);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 10;
            gbCons.gridheight = 0;
            this.m_insertButton = new JButton(VWResource.a_addArrows);
            this.m_insertButton.addActionListener(this);
            panel.add((Component)this.m_insertButton, gbCons);
            this.m_controls.addElement(this.m_insertButton);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(0, 0, 4, 0);
            panel.add((Component)this.createOperationButtons(), gbCons);
            gbCons.fill = 1;
            ++gbCons.gridy;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(0, 0, 0, 0);
            this.m_conditionArea = new JTextArea();
            this.m_conditionArea.setLineWrap(true);
            this.m_conditionArea.setWrapStyleWord(true);
            this.m_conditionArea.setRows(3);
            this.m_conditionArea.getDocument().addDocumentListener(this);
            this.m_conditionArea.addMouseListener(this);
            this.m_controls.addElement(this.m_conditionArea);
            this.m_conditionScrollPane = new JScrollPane(this.m_conditionArea);
            this.m_conditionScrollPane.setHorizontalScrollBarPolicy(31);
            panel.add((Component)this.m_conditionScrollPane, gbCons);
            this.m_controls.addElement(this.m_conditionScrollPane);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createOperationButtons() {
        this.m_expressionToolbar = new VWExpressionToolbar(4);
        this.m_expressionToolbar.addExpressionToolbarActionListener(this);
        this.m_controls.addElement(this.m_expressionToolbar);
        return this.m_expressionToolbar;
    }

    private void updateRouteCondition() {
        if (this.m_conditionArea == null || this.m_routeDefinition == null || this.m_authPropertyData == null) {
            return;
        }
        String condition = this.m_conditionArea.getText();
        if (condition != null && condition.length() > 0) {
            this.m_routeDefinition.setCondition(condition);
        } else {
            this.m_routeDefinition.setCondition(null);
        }
        this.m_authPropertyData.setDirty();
        this.m_changedItems = new Vector();
        this.m_changedItems.addElement(this.m_routeDefinition);
        this.notifyPropertyChange();
    }

    private void launchExpressionBuilder() {
        VWStepDefinition stepDef = null;
        try {
            VWMapNode mapNode = this.m_routeDefinition.getSourceStep();
            if (mapNode instanceof VWStepDefinition) {
                stepDef = (VWStepDefinition)mapNode;
            }
            VWExpressionBuilderDialog expressionBuilderDlg = new VWExpressionBuilderDialog(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData, stepDef, this.m_conditionArea.getText(), 2719);
            expressionBuilderDlg.init();
            expressionBuilderDlg.setVisible(true);
            if (expressionBuilderDlg.getDialogResult() == 0) {
                String expressionString = expressionBuilderDlg.getExpressionString();
                this.m_conditionArea.setText(expressionString);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void enableExpressionControls(boolean bDisplay) {
        boolean bIsEditable = this.m_authPropertyData.isCurrentMapEditable();
        if (this.m_routeTabbedPane != null) {
            this.m_routeTabbedPane.setEnabled(bDisplay && bIsEditable);
        }
        if (this.m_insertButton != null) {
            this.m_insertButton.setEnabled(bDisplay && bIsEditable);
        }
        if (this.m_expressionToolbar != null) {
            this.m_expressionToolbar.setEnabled(bDisplay && bIsEditable);
        }
        if (this.m_conditionArea != null) {
            this.m_conditionArea.setEnabled(bDisplay);
        }
        if (this.m_conditionScrollPane != null) {
            this.m_conditionScrollPane.setEnabled(bDisplay);
        }
    }
}

